
#ifndef _1_CRYS_SEP_ATP_HASH_Acceptance_h_H
#define _1_CRYS_SEP_ATP_HASH_Acceptance_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_SEP_ATP_Defines.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 12 12:56:19 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_SEP_ATP_HASH_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/******** Defines **********/
/******** Enums ************/
/******** Typedefs  **********/
/******** Structs  **********/

/******** Public Variables ********/
/******** Public Functions ********/
/***********************************************************************
* Function Name:                                                           
*  SEPQA_HASH_NotIntegrated         
* 
* Inputs:
* OperationMode - The operation mode : MD5 or SHA1.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* DataExpSize - The size of the expected data
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
* This function is qa external application on the SEP, 
* that executes HASH not integrated test
* Algorithm:   
* 1. Allocate memory buffers
* 2. Call the CRYS_HASH_Init function to start the hash process
* 3. Call the CRYS_HASH_Update - This function is called N times
*                                (N = number of blocks in data each block is 16byte)
* 4. Call the CRYS_HASH_Finish to end the HASH process and get the Digest result
* 5. Compare the outputted result to the expected one                                                   
* 6. Free allocated buffers
*
**************************************************************************************/                                
CRYSError_t SEPQA_HASH_NotIntegrated(
									CRYS_HASH_OperationMode_t   OperationMode,
									DxUint8_t                  *DataIn_ptr,
									DxUint32_t                  DataInSize,
									DxUint8_t                  *ExpectedData_ptr,        
									DxUint32_t                  DataExpSize,
									DxUint8_t                  *FailureFunctionNameOut_ptr);


/***********************************************************************
* Function Name:                                                           
*  SEPQA_HASH_Integrated         
* 
* Inputs:
* OperationMode - The operation mode : MD5 or SHA1.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* DataExpSize - The size of the expected data
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
* This function is qa external application on the SEP, 
* that executes HASH integrated test
* Algorithm:   
* 1. Allocate memory buffers
* 2. Call the CRYS_HASH function to execute the hash process
* 3. Compare the outputted result to the expected one                                                   
* 4. Free allocated buffers
*
**************************************************************************/                                
CRYSError_t SEPQA_HASH_Integrated(CRYS_HASH_OperationMode_t  OperationMode,
								  DxUint8_t                  *DataIn_ptr,
								  DxUint32_t                  DataInSize,
								  DxUint8_t                  *ExpectedData_ptr,        
								  DxUint32_t                  DataExpSize,
								  DxUint8_t                   *FailureFunctionNameOut_ptr);



#ifdef __cplusplus
}
#endif

#endif


